/*
 * Decompiled with CFR 0.152.
 */
package net.xmzykj.setting;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import net.xmzykj.MacApplication;
import net.xmzykj.setting.Setting;
import net.xmzykj.setting.SettingReader;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.web.embedded.tomcat.ConnectorStartFailedException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SettingApplication
extends Application {
    KeyCombination ctrlP = KeyCodeCombination.keyCombination((String)"Ctrl+I");
    KeyCombination ctrlX = KeyCodeCombination.keyCombination((String)"Ctrl+O");
    private Stage primaryStage;
    private Setting setting;
    private final Label statusLabel = new Label("\u670d\u52a1\u672a\u542f\u52a8");
    private Button startupBtn;
    private Button stopBtn;
    private Button quitBtn;
    private String serverPort = "9527";

    public static void main(String[] args) {
        SettingApplication.run();
    }

    public static void run() {
        SettingApplication.launch(null);
    }

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.setting = SettingReader.read();
        this.initLayout();
        this.primaryStage.show();
    }

    protected void initLayout() {
        String title = "\u6728\u4e4b\u68ee\u96c6\u56e2";
        Platform.setImplicitExit((boolean)false);
        SystemTray systemTray = SystemTray.getSystemTray();
        URL imageUrl = this.getClass().getResource("/icon.png");
        Image image = Toolkit.getDefaultToolkit().createImage(imageUrl);
        TrayIcon trayIcon = new TrayIcon(image, title);
        trayIcon.addActionListener(event -> Platform.runLater(() -> this.primaryStage.show()));
        PopupMenu popup = new PopupMenu();
        trayIcon.setPopupMenu(popup);
        try {
            systemTray.add(trayIcon);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        this.primaryStage.setTitle(title);
        this.primaryStage.setResizable(false);
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Label serverPortLabel = new Label("\u7aef\u53e3\uff1a" + this.serverPort);
        grid.add((Node)serverPortLabel, 0, 1);
        Scene scene = new Scene((Parent)grid, 220.0, 120.0);
        this.primaryStage.setScene(scene);
        this.startupBtn = new Button("\u542f\u52a8");
        this.stopBtn = new Button("\u505c\u6b62");
        this.quitBtn = new Button("\u9000\u51fa");
        grid.add((Node)this.statusLabel, 0, 4);
        this.startupBtn.setOnAction(event -> {
            if (!this.validateServerPort(this.serverPort).booleanValue()) {
                return;
            }
            this.setting.setServerPort(this.serverPort);
            this.commonMessage("\u542f\u52a8\u4e2d...");
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(() -> MacApplication.start(startedEvent -> {
                this.successMessage("\u542f\u52a8\u6210\u529f");
                this.serverStartedStatus();
            }, failedEvent -> {
                if (failedEvent.getException() instanceof ConnectorStartFailedException) {
                    this.errorMessage("\u7aef\u53e3\u88ab\u5360\u7528");
                } else {
                    this.errorMessage("\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5218\u65b0\u6bc5");
                }
                this.serverStoppedStatus();
            }));
            executorService.shutdown();
        });
        this.stopBtn.setDisable(true);
        this.stopBtn.setOnAction(event -> {
            MacApplication.stop();
            this.serverStoppedStatus();
            this.commonMessage("\u670d\u52a1\u5df2\u505c\u6b62");
        });
        this.quitBtn.setOnAction(event -> System.exit(0));
        HBox btnBox = new HBox(10.0);
        btnBox.setAlignment(Pos.BOTTOM_LEFT);
        btnBox.getChildren().addAll((Object[])new Node[]{this.startupBtn, this.stopBtn, this.quitBtn});
        grid.add((Node)btnBox, 0, 8);
        this.primaryStage.setOnCloseRequest(event -> this.hide());
    }

    public void hide() {
        Platform.runLater(() -> {
            if (SystemTray.isSupported()) {
                this.primaryStage.hide();
            } else {
                System.exit(0);
            }
        });
    }

    protected Boolean validateServerPort(String port) {
        if (StringUtils.isBlank((CharSequence)port)) {
            this.errorMessage("\u8bf7\u8f93\u5165\u670d\u52a1\u7aef\u53e3\uff01");
            return false;
        }
        if (!Pattern.matches("^[1-9]\\d{1,3}$", port)) {
            this.errorMessage("\u7aef\u53e3\u5fc5\u987b\u4e3a\u975e0\u5f00\u5934\u7684\uff0c\u4e0d\u8d85\u8fc74\u4f4d\u7684\u6570\u5b57\uff01");
            return false;
        }
        return true;
    }

    protected void commonMessage(String message) {
        Platform.runLater(() -> {
            this.statusLabel.setText(message);
            this.statusLabel.setTextFill((Paint)Color.BLACK);
        });
    }

    protected void errorMessage(String message) {
        Platform.runLater(() -> {
            this.statusLabel.setText(message);
            this.statusLabel.setTextFill((Paint)Color.RED);
        });
    }

    protected void successMessage(String message) {
        Platform.runLater(() -> {
            this.statusLabel.setText(message);
            this.statusLabel.setTextFill((Paint)Color.GREEN);
        });
    }

    protected void serverStartedStatus() {
        this.startupBtn.setDisable(true);
        this.stopBtn.setDisable(false);
        this.quitBtn.setDisable(false);
    }

    protected void serverStoppedStatus() {
        this.startupBtn.setDisable(false);
        this.stopBtn.setDisable(true);
        this.quitBtn.setDisable(true);
    }
}

